﻿[CmdletBinding()]
param ()

$scriptVer = '3.1'

if (Test-Path -Path "$env:TEMP\Manage-UserSettings.Log-Transcription.Log") {
    Remove-Item -Path "$env:TEMP\Manage-UserSettings.Log-Transcription.Log" -Force
}
Start-Transcript -Path "$env:TEMP\Manage-UserSettings.Log-Transcription.Log"

# Test Registry Item Function
Function Test-RegItem {
    [CmdletBinding()]
    param (
        [Parameter(Mandatory = $true)]
        [String]
        $Path,

        [Parameter(Mandatory = $true)]
        [String]
        $Value
    )

    try {
        Get-ItemProperty -Path $Path -Name $Value -ErrorAction Stop | Out-Null
        return $true
    }
    catch {
        return $false
    }
}

$data = Import-LocalizedData -BaseDirectory $PSScriptRoot -FileName 'User-SettingsData.psd1'

foreach ($item in $data.GetEnumerator())
{
    if ([string]::IsNullOrEmpty((Get-Variable -Name $item.Name -ErrorAction SilentlyContinue).Value))
    {
        Set-Variable -Name $item.Name -Value $item.Value
    }
}

# Handle Registry Entries for any Current User
$logonUsers = (Get-ChildItem -Path 'REGISTRY::HKEY_USERS\' | Where-Object -FilterScript {($_.Name -like '*S-1-12-8*' -or $_.Name -like '*S-1-5-21*') -and $_.Name -notlike '*Classes'}).Name
Write-Host 'Identifying current user.'

if ($null -eq $logonUsers) {
    Write-Host 'Logged on user not detected. Skipping setting registry.'
    Write-Host 'Script finished'
    Stop-Transcript
    exit
}

foreach ($currentUser in $logonUsers) {
    $sid = $currentUser.Split('\')[1]
    $userName = (Get-ItemPropertyValue -Path "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\ProfileList\$sid" -Name ProfileImagePath).Split('\')[-1]

    # Update registry entries to set depending whether user is a local user or entra user
    if ($currentUser -match 'S-1-5-21') {
        $itemsToSet = $items + $localUserItems
        $entriesToSet = $entries + $localUserEntries
    }
    else {
        $itemsToSet = $items
        $entriesToSet = $entries
    }

    $userPath = 'Registry::' + $currentUser

    foreach ($item in $itemsToSet)
    {
        $path = $userPath + '\' + $item.Path
        if (!(Get-Item -Path "$path\$($item.Name)" -ErrorAction SilentlyContinue)) {
            New-Item -Path $path -Name $item.Name
        }
    }
    
    foreach ($entry in $entriesToSet) {
        $key = $userPath + '\' + $entry.Key

        if ((Test-RegItem -Path $key -Value $entry.ValueName) -eq $false) {
            New-ItemProperty -Path $key -Name $entry.ValueName -PropertyType $entry.ValueType -Value $entry.ValueData
        }
        elseif ((Get-ItemProperty -Path $key | Select-Object -ExpandProperty $entry.ValueName) -ne $entry.ValueData) {
            Set-ItemProperty -Path $key -Name $entry.ValueName -Value $entry.ValueData
        }
    }

    if ($currentUser -match 'S-1-5-21') {
        foreach ($remove in $removes) {
            $key = $userPath + '\' + $remove.Key

            if (Test-RegItem -Path $key -Value $remove.ValueName) {
                Remove-ItemProperty -Path $key -Name $remove.ValueName -Force
            }
        }
    }

    # Reset Data Arrays
    $itemsToSet = $null
    $entriesToSet = $null
}

Write-Host 'Script finished'
Stop-Transcript
exit
